using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    public struct P
    {
        public int X, Y;
        public P(int x, int y) { X = x; Y = y; }
    }

    static int C(P o, P a, P b)
    {
        return (a.X - o.X) * (b.Y - o.Y) - (a.Y - o.Y) * (b.X - o.X);
    }

    static List<P> H(List<P> p)
    {
        p = p.OrderBy(x => x.X).ThenBy(x => x.Y).ToList();
        List<P> l = new List<P>();

        foreach (P q in p)
        {
            while (l.Count >= 2 && C(l[l.Count - 2], l[l.Count - 1], q) <= 0)
                l.RemoveAt(l.Count - 1);
            l.Add(q);
        }

        List<P> u = new List<P>();
        foreach (P q in p.AsEnumerable().Reverse())
        {
            while (u.Count >= 2 && C(u[u.Count - 2], u[u.Count - 1], q) <= 0)
                u.RemoveAt(u.Count - 1);
            u.Add(q);
        }

        l.RemoveAt(l.Count - 1);
        u.RemoveAt(u.Count - 1);

        l.AddRange(u);
        return l;
    }

    static double A(List<P> p)
    {
        int n = p.Count;
        double a = 0;
        for (int i = 0; i < n; i++)
        {
            int j = (i + 1) % n;
            a += p[i].X * p[j].Y - p[i].Y * p[j].X;
        }
        return Math.Abs(a) / 2;
    }

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        List<P> p = new List<P>();

        for (int i = 0; i < n; i++)
        {
            int[] c = Console.ReadLine().Split().Select(int.Parse).ToArray();
            p.Add(new P(c[0], c[1]));
        }

        List<P> h = H(p);

        if (h.Count > n - 1)
        {
            h.RemoveAt(h.Count - 1);
        }

        Console.WriteLine((int)A(h));
    }
}